package gov.va.vinci.dart.json;

import java.util.ArrayList;
import java.util.List;

import gov.va.vinci.dart.json.atom.LinkListView;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="request")
@XmlType(name="Request", propOrder={
		"requestId",
		"activityId",
		"workflowId",
		"trackingNumber",
		"activityName",
		"officialName",
		"requestType",
		"preparatoryRequest",
		"researchRequest",
		"operationsRequest",
		"submitted",
		"created",
		"updated",
		"updatedBy",
		"daysElapsed",
		"reviewId",
		"initialReview",
		"finalReview",
		"editable",
		"amendable",
		"amendment",
		"amendmentNarrative",
		"contact",
		"padLeft",
		"workflowStatusList",
		"workflowNameList",
		"links"
})
public class RequestView {

	private int requestId;
	private int activityId;
	private int workflowId = 0;	//default to 0
	private String trackingNumber;
	private String activityName;
	private String officialName;
	private String requestType;
	private boolean researchRequest = false;
	private boolean operationsRequest = false;
	private boolean preparatoryRequest = false;
	private String submitted;
	private String created;
	private String updated;
	private String updatedBy;
	private String daysElapsed = "";
	private int reviewId;
	private boolean initialReview;
	private boolean finalReview;
	private boolean editable;
	private boolean amendable = false;
	private boolean amendment = false;
	private String amendmentNarrative;
	private String contact;

	private String padLeft = "";
	private List<WorkflowStatusView> workflowStatusList = new ArrayList<WorkflowStatusView>();
	private List<WorkflowNameView> workflowNameList = new ArrayList<WorkflowNameView>();
	
	private LinkListView links;
	
	
	public int getRequestId() {
		return requestId;
	}

	public void setRequestId(int requestId) {
		this.requestId = requestId;
	}

	public String getTrackingNumber() {
		return trackingNumber;
	}

	public void setTrackingNumber(String trackingNumber) {
		this.trackingNumber = trackingNumber;
	}

	public String getActivityName() {
		return activityName;
	}

	public void setActivityName(String activityName) {
		this.activityName = activityName;
	}

	public String getRequestType() {
		return requestType;
	}

	public void setRequestType(String requestType) {
		this.requestType = requestType;
	}

	public String getCreated() {
		return created;
	}

	public void setCreated(String created) {
		this.created = created;
	}

	public String getSubmitted() {
		return submitted;
	}

	public void setSubmitted(String submitted) {
		this.submitted = submitted;
	}

	public String getUpdated() {
		return updated;
	}

	public void setUpdated(String updated) {
		this.updated = updated;
	}

	public String getUpdatedBy() {
		return updatedBy;
	}

	public void setUpdatedBy(String updatedBy) {
		this.updatedBy = updatedBy;
	}

	public int getActivityId() {
		return activityId;
	}

	public void setActivityId(int activityId) {
		this.activityId = activityId;
	}

	public int getWorkflowId() {
		return workflowId;
	}

	public void setWorkflowId(int workflowId) {
		this.workflowId = workflowId;
	}	
	
	public String getDaysElapsed() {
		return daysElapsed;
	}

	public void setDaysElapsed(String daysElapsed) {
		this.daysElapsed = daysElapsed;
	}

	public void setDaysElapsedWithLabel(long daysElapsedVal) {
		
		StringBuffer daysElapsedStr = new StringBuffer();
		
		daysElapsedStr.append( daysElapsedVal );

		if( daysElapsedVal == 1 )
			daysElapsedStr.append(" Day");
		else
			daysElapsedStr.append(" Days");
		
		setDaysElapsed( daysElapsedStr.toString() );
	}
	
	
	public int getReviewId() {
		return reviewId;
	}

	public void setReviewId(int reviewId) {
		this.reviewId = reviewId;
	}

	public boolean isInitialReview() {
		return initialReview;
	}

	public void setInitialReview(boolean initialReview) {
		this.initialReview = initialReview;
	}

	public boolean isFinalReview() {
		return finalReview;
	}

	public void setFinalReview(boolean finalReview) {
		this.finalReview = finalReview;
	}

	public boolean isEditable() {
		return editable;
	}

	public void setEditable(boolean editable) {
		this.editable = editable;
	}

	public String getOfficialName() {
		return officialName;
	}

	public void setOfficialName(String officialName) {
		this.officialName = officialName;
	}

	public String getAmendmentNarrative() {
		return amendmentNarrative;
	}

	public void setAmendmentNarrative(String amendmentNarrative) {
		this.amendmentNarrative = amendmentNarrative;
	}
	
	public String getContact() {
		return contact;
	}

	public void setContact(String contact) {
		this.contact = contact;
	}
	
	public boolean isAmendable() {
		return amendable;
	}

	public void setAmendable(boolean amendable) {
		this.amendable = amendable;
	}	
	
	public boolean isAmendment() {
		return amendment;
	}

	public void setAmendment(boolean amendment) {
		this.amendment = amendment;
	}

	public boolean isResearchRequest() {
		return researchRequest;
	}

	public void setResearchRequest(boolean researchRequest) {
		this.researchRequest = researchRequest;
	}
	
	public boolean isPreparatoryRequest() {
        return preparatoryRequest;
    }

    public void setPreparatoryRequest(boolean preparatoryRequest) {
        this.preparatoryRequest = preparatoryRequest;
    }

    public boolean isOperationsRequest() {
		return operationsRequest;
	}

	public void setOperationsRequest(boolean operationsRequest) {
		this.operationsRequest = operationsRequest;
	}

	public LinkListView getLinks() {
		return links;
	}

	public void setLinks(LinkListView links) {
		this.links = links;
	}

	public String getPadLeft() {
		return padLeft;
	}

	public void setPadLeft(String padLeft) {
		this.padLeft = padLeft;
	}
	
	public List<WorkflowStatusView> getWorkflowStatusList() {
		return workflowStatusList;
	}

	public List<WorkflowNameView> getWorkflowNameList() {
		return workflowNameList;
	}

}
